<?php
require_once 'admin_config.php';
requireAdminAuth(); // Ensure only admins can access this page

$message = '';
$message_type = '';

// Get service ID from URL
$service_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($service_id > 0) {
    try {
        $conn = getAdminDBConnection();

        // Check if the service exists before attempting to delete
        $stmt = $conn->prepare("SELECT title FROM services WHERE id = ?");
        if ($stmt === false) {
            throw new Exception('Prepare select statement failed: ' . $conn->error);
        }
        $stmt->bind_param('i', $service_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows === 0) {
            $message = 'الخدمة المطلوبة غير موجودة.';
            $message_type = 'danger';
        }
        $stmt->close();

        // Handle deletion on POST request (confirmation)
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_delete'])) {
            $stmt = $conn->prepare("DELETE FROM services WHERE id = ?");
            if ($stmt === false) {
                throw new Exception('Prepare delete statement failed: ' . $conn->error);
            }
            $stmt->bind_param('i', $service_id);
            if ($stmt->execute()) {
                $message = 'تم حذف الخدمة بنجاح.';
                $message_type = 'success';
                // Redirect back to admin_services.php after successful deletion
                header('Location: admin_services.php?message=' . urlencode($message) . '&type=' . $message_type);
                exit();
            } else {
                $message = 'حدث خطأ أثناء حذف الخدمة: ' . $conn->error;
                $message_type = 'danger';
            }
            $stmt->close();
        }

    } catch (Exception $e) {
        $message = 'خطأ: ' . $e->getMessage();
        $message_type = 'danger';
    }
} else {
    $message = 'معرف الخدمة غير صالح.';
    $message_type = 'danger';
}

require_once '../header.php'; // Include header for consistent styling
?>

<div class="container bg-dark text-white mt-5">
    <div class="card">
        <div class="card-header">
            <h3 class="mb-0">حذف خدمة</h3>
        </div>
        <div class="card-body">
            <?php if (!empty($message)): ?>
                <div class="alert alert-<?= htmlspecialchars($message_type) ?>" role="alert">
                    <?= htmlspecialchars($message) ?>
                </div>
            <?php endif; ?>

            <?php if ($message_type !== 'success' && $service_id > 0): ?>
                <p class="lead">هل أنت متأكد أنك تريد حذف هذه الخدمة؟ هذا الإجراء لا يمكن التراجع عنه.</p>
                <form method="POST">
                    <input type="hidden" name="confirm_delete" value="1">
                    <button type="submit" class="btn btn-danger">تأكيد الحذف</button>
                    <a href="admin_services.php" class="btn btn-secondary">إلغاء</a>
                </form>
            <?php elseif ($message_type === 'success'): ?>
                <p><a href="admin_services.php" class="btn btn-primary">العودة إلى إدارة الخدمات</a></p>
            <?php endif; ?>

        </div>
    </div>
</div>

<?php require_once '../footer.php'; ?> 